' Copyright (c) 2018 Roku, Inc. All rights reserved.

sub RunUserInterface(args)
    m.args = args
    if Type(GetSceneName) <> "<uninitialized>" AND GetSceneName <> invalid AND GetInterface(GetSceneName, "ifFunction") <> invalid then
        StartSGDEXChannel(GetSceneName(), args)
    else
        ? "Error: SGDEX, please implement 'GetSceneName() as String' function and return name of your scene that is extended from BaseScene"
    end if
end sub

sub StartSGDEXChannel(componentName, args)
    screen = CreateObject("roSGScreen")
    m.port = CreateObject("roMessagePort")
    screen.SetMessagePort(m.port)
    input = CreateObject("roInput")
    input.setMessagePort(m.port)

    m.global = screen.getGlobalNode()
    m.global.AddFields({manifest : ParseManifest()})
    m.global.AddFields({Udata:{},Cdata:{},theme:{},timegrid : "live",lastPlayed :{},epg_roku : true, Uthemes : {}, Cthemes : {}, ParentalLock : true})

    scene = screen.CreateScene(componentName)
    scene.theme = {
        global: {
            OverhangVisible : "false"
        }
    }
     
    screen.Show()
    scene.ObserveField("exitChannel", m.port)
    scene.launch_args = args
    
    input = CreateObject("roInput")
    input.setMessagePort(m.port)
    
    while (true)
        msg = Wait(0, m.port)
        msgType = Type(msg)
        if msgType = "roSGScreenEvent"
            if msg.IsScreenClosed() then return
        else if msgType = "roSGNodeEvent"
            field = msg.getField()
            data = msg.getData()
            if field = "exitChannel" and data = true
                END
            end if
        else if msgType = "roInputEvent"
            scene.input_args = msg.getInfo()
            getDeepLinks(msg.getInfo())
        end if
    end while
end sub

Function getDeepLinks(args) as Object
    deeplink = Invalid

    if args.contentid <> Invalid and args.mediaType <> Invalid
        deeplink = {
            id: args.contentId
            type: args.mediaType
        }
    end if

    return deeplink
end Function


Function ParseManifest()
    manifest = ReadAsciiFile("pkg:/manifest")
    lines = manifest.Tokenize(chr(10))
    aa = {}
    for each line in lines
        entry = line.Tokenize("=")
        aa.AddReplace(entry[0],entry[1])
    end for
    return aa
End Function

