' Copyright (c) 2018 Roku, Inc. All rights reserved.

sub Init()
    m.titleLabel = m.top.findNode("title")
    m.descriptionLabel = m.top.findNode("description")
    m.meta = m.top.findNode("meta")

    m.date = CreateObject("roDateTime")
end sub

sub onMaxWidthChange()
    m.titleLabel.width = m.top.maxWidth
    m.descriptionLabel.width = m.top.maxWidth
     m.meta.width = m.top.maxWidth
end sub

sub onContentSet()
    content = m.top.content
    if content <> invalid
        titleLabelText = content.title
        if content.releaseDate <> invalid and val(content.releaseDate) > 0
            titleLabelText += " | " + content.releaseDate
        end if 
        if content.StarRating <> invalid and content.StarRating > 0
            titleLabelText += " | " + generateStarsRating(content.StarRating)
        end if 
        m.titleLabel.text = titleLabelText
        m.descriptionLabel.text = content.description

        if content.PLAYSTART <> 0
            m.date.FromSeconds(content.PLAYSTART)
            m.meta.text = m.date.AsDateString("short-month-no-weekday")+"  "+GetTimeFromStrotTime(content.PLAYSTART)+"-"+GetTimeFromStrotTime(content.PLAYSTART+content.PLAYDURATION)
        else
            m.meta.text = ""
        end if
    end if
end sub

function generateStarsRating(starRating as Integer, maxRating = 100 as Integer, maxCount = 5 as Integer) as String
    stars = {
        empty : chr(9734)
        full  : chr(9733)
    }
    result = ""
    pointsPerStar = maxRating / maxCount
    fullCount = starRating / pointsPerStar
    if fullCount - int(fullCount) > 0.5 then 
        fullCount = int(fullCount) + 1
    else
        fullCount = int(fullCount)
    end if
    emptyCount = maxCount - fullCount
    
    while fullCount > 0
        result+=stars.full
        fullCount--
    end while
    while emptyCount > 0
        result+=stars.empty
        emptyCount--
    end while
    
    return result
end function


Function GetTimeFromStrotTime(numSeconds = 0 As Integer) as String
    date = CreateObject("roDateTime")
    date.FromSeconds(numSeconds)
    date.ToLocalTime()
    
    string = "" 
    if date.GetHours() > 12
        string = Int(date.GetHours() - 12).ToStr()
    else
        string = date.GetHours().toStr()
    end if

    if date.GetMinutes() = 0
        string = string + ":" + "00"
    else
        if Len(date.GetMinutes().toStr()) = 1
            string = string + ":" + "0"+date.GetMinutes().toStr()
        else
            string = string + ":" + date.GetMinutes().toStr()
        end if
    end if
    

    if date.GetHours() > 12
        string = string+"pm"
    else
        string = string+"am"
    end if
    return string
End Function