Function init()

    m.registry = RegistryUtil().read("UserInfo", m.global.manifest.key)  
    if m.registry <> invalid
        m.registry = parsejson(m.registry)  
    end if

    m.spinner = m.top.FindNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.item_poster = m.top.findnode("item_poster")
    m.item_title = m.top.findnode("item_title")
    m.item_desc = m.top.findnode("item_desc")
    m.item_cast = m.top.findnode("item_cast")
    m.item_director = m.top.findnode("item_director")
    m.item_genre = m.top.findnode("item_genre")

    m.buttons = m.top.findnode("buttons")
    m.buttons.ObserveField("rowitemselected", "onbuttonselected")


    m.grid = m.top.findnode("grid")
    m.grid.ObserveField("rowitemselected", "onRowItemselected")

    m.lastfocus = invalid

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentChange")

    m.main = m.top.findnode("main")

    m.backRec = m.top.findnode("backRec")
    m.backRec.color = GetTheme("roku_background_overlay")
End Function


sub OnContentChange()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            if m.top.content <> invalid and m.top.content.HandlerConfig <> invalid then
                HandlerConfig = m.top.content.HandlerConfig
                if m.top.content.itemdata.stream_type = "movie"
                    additionalFields = {
                        id : "GetMoviedetails"
                        query : m.top.content.itemdata.stream_id.tostr()
                    }
                    m.top.findnode("screenTitle").text = "Movies | "+ m.top.content.itemdata.name
                else m.top.content.itemdata.CONTENTTYPE = 2
                    additionalFields = {
                        id : "GetSeriesdetails"
                        query : m.top.content.itemdata.series_id
                    }
                    m.top.findnode("screenTitle").text = "TVShows | "+ m.top.content.itemdata.name
                end if
                LoadMoreContent(m.top.content, HandlerConfig,additionalFields)
            end if
            ShowBusySpinner(true)
        else if FieldChanged = "itemcontent"
            m.main.visible = true
            SetItemUI(m.top.content.itemcontent)
            ShowBusySpinner(false)    
        end if
      end if
   end if
end sub

Function OnWasShown()
    if m.lastfocus <> invalid
        m.lastfocus.setfocus(true)
    end if
End Function

Function onRowItemselected(event as object)
    if m.top.content.itemdata.CONTENTTYPE = 1
        index = event.getData()
        content = m.grid.content.getchild(index[0]).getchild(index[1])
        m.top.content.setFields({itemdata : content})
        m.top.content.setFields({FieldChanged : "SetContent"})
    else
        m.top.rowItemSelected = event.getData()
    end if
End Function

Function onbuttonselected(event as object)
    index = event.getData()

    if index[1] = 0
        if  m.top.content.itemdata.stream_type = "movie"
            content = CreateObject("roSGNode", "ContentNode")
            ext = m.top.content.itemcontent.movie_data.container_extension
            content.title = m.top.content.itemcontent.movie_data.name
            content.url = m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port+"/movie/"+m.registry.user_info.username+"/"+m.registry.user_info.password+"/"+m.top.content.itemdata.stream_id.tostr()+"."+ext
            m.top.VideoContent = content
        else
            m.top.rowItemSelected = [0,0]
        end if
    else if index[1] = 1
        if  m.top.content.itemdata.stream_type = "movie"
            item = { 
                stream_id : m.top.content.itemdata.stream_id
                stream_icon : m.top.content.itemdata.stream_icon
                stream_type : m.top.content.itemdata.stream_type
                name : m.top.content.itemdata.name
            }
            HandleFavAssets(item,"Movies")
            present = GetFavAssets(item,"Movies")
            if present = true
                m.buttons.content.getchild(0).getchild(index[1]).update({title : "Remove from Favorite"})
            else 
                m.buttons.content.getchild(0).getchild(index[1]).update({title : "Add to Favorite"})
            end if
        else
            item = { 
                series_id : m.top.content.itemdata.series_id
                cover : m.top.content.itemdata.cover
                name : m.top.content.itemdata.name
            }
            HandleFavAssets(item,"TVShows")
            present = GetFavAssets(item,"TVShows")
            if present = true
                m.buttons.content.getchild(0).getchild(index[1]).update({title : "Remove from Favorite"})
            else 
                m.buttons.content.getchild(0).getchild(index[1]).update({title : "Add to Favorite"})
            end if
        end if
    end if
    
End Function

Function SetItemUI(itemdata as object)
    if itemdata.info.movie_image <> invalid
        m.item_poster.uri = itemdata.info.movie_image
    else if itemdata.info.cover <> invalid
        m.item_poster.uri = itemdata.info.cover
    end if

    m.item_title.text = itemdata.info.name
    if itemdata.info.description <> invalid
        m.item_desc.text = itemdata.info.description
    else if itemdata.info.plot <> invalid
        m.item_desc.text = itemdata.info.plot
    end if

    m.item_cast.text = itemdata.info.cast
    m.item_director.text = itemdata.info.director
    m.item_genre.text = itemdata.info.genre

    if itemdata.seasons <> invalid
        SetButtons()
        SeasonRowlistContent(itemdata)
    else
        SetButtons()   
       ' ConvetToRowlistContent(m.top.content.relatedContent) 
    end if
End Function

Function SetButtons() 
    m.buttons.visible = "true"
    buttons = ["Play","Add to Favorite"]
    content = CreateObject("roSGNode", "ContentNode")
    row = CreateObject("roSGNode", "ContentNode")
    for each button in buttons
        item = CreateObject("roSGNode", "ContentNode")
        if button = "Add to Favorite"
            if  m.top.content.itemdata.stream_id <> invalid and GetFavAssets({stream_id : m.top.content.itemdata.stream_id},"Movies")
                item.title = "Remove From Favorites"
                item.id = "Remove From Favorites"
            else if m.top.content.itemdata.series_id <> invalid and GetFavAssets({series_id : m.top.content.itemdata.series_id},"TVShows")
                item.title = "Remove From Favorites"
                item.id = "Remove From Favorites"
            else
                item.title = "Add to Favorites"
                item.id = "Add to Favorites"
            end if
        else
            item.title = button
            item.id = button
        end if
        row.appendChild(item)
    end for
    content.appendChild(row)
    m.buttons.content = content
    m.buttons.jumpToItem = 0
    m.buttons.setfocus(true)
    m.lastfocus = m.buttons
End Function

function CheckInArray(fav,id)
    handle = false
    for each item in fav
        if item.id.tostr() = id.tostr()
            handle = true
        end if
    end for

    return handle
end function

function DeleteInArray(fav,id)
    handle = false
    i = 0
    for each item in fav
        if item.id.tostr() = id.tostr()
           fav.Delete(i) 
        end if
        i = i + 1
    end for
    return fav
end function


function ConvetToRowlistContent(data as object)
    content = CreateObject("roSGNode", "ContentNode")
    row = CreateObject("roSGNode", "ContentNode")
    row.title = "Related Movies"
    for each movie in data 
        item = CreateObject("roSGNode", "ContentNode")
        if movie.stream_icon <> invalid
            item.hdposterurl = movie.stream_icon
        else if movie.cover <> invalid
            item.hdposterurl = movie.cover
        end if

        if movie.plot <> invalid and movie.plot <> ""
            item.description = movie.plot
        end if

        if movie.backdrop_path <> invalid and movie.backdrop_path.count() > 0
            item.sdposterurl = movie.backdrop_path[0]
        end if

        item.title = movie.name

        if movie.stream_type = "movie"
            item.ContentType = "movie"
        else if movie.series_id <> invalid
            item.contentType = "series"    
        end if

        if movie.stream_id <> invalid
            item.id = movie.stream_id
        else if movie.series_id <> invalid
            item.id = movie.series_id
        end if
        row.appendchild(item)
    end for
    content.appendChild(row)
    'm.grid.rowItemSize="[[195.9, 259.5]]"
    m.grid.itemComponentName = "GridRowList"
    m.grid.content = content

    if  m.grid.content.getchild(0).getChildCount() = 0
        m.grid.visible = false
    end if
end function


function SeasonRowlistContent(data as object)
    if data.episodes <> invalid 
    content = CreateObject("roSGNode", "ContentNode")
        for i=1 to data.episodes.count()
            if data.episodes[i.tostr()] <> invalid
                row = CreateObject("roSGNode", "ContentNode")
                row.title = "Season "+data.episodes[i.tostr()][0].season.tostr()
                for each episode in data.episodes[i.tostr()]
                    item = CreateObject("roSGNode", "ContentNode")
                    item.hdposterurl = episode.info.movie_image
                    item.title = episode.title
                    item.EpisodeNumber = episode.episode_num.tostr()
                    item.NumEpisodes = episode.season
                    item.description = episode.info.plot
                    item.url = m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port+"/series/"+m.registry.user_info.username+"/"+m.registry.user_info.password+"/"+episode.id+"."+episode.container_extension
                    row.appendchild(item)
                end for
                content.appendchild(row)
            end if
        end for
        'm.grid.rowItemSize="[[195.9, 249.5]]"
        m.grid.itemComponentName = "SeasonGridlistItem"
        m.grid.content = content
        m.lastfocus = m.grid
    end if
end function


sub LoadMoreContent(content, HandlerConfig,additionalFields)
    'ShowBusySpinner(true)

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            'ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additionalFields)
end sub

function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "down" 
            if m.buttons.HasFocus() and m.grid.content <> invalid and m.grid.visible = true
                m.main.visible = false
                m.grid.translation="[50, 240]"
                m.grid.setfocus(true)
            end if        
            handled = true
        else if key = "up" 
            if m.grid.HasFocus() and m.buttons.content <> invalid
                m.grid.translation="[50, 840]"
                m.main.visible = true
                m.buttons.setfocus(true)
            end if
            handled = true
        end if
    end if
    return handled
end function


sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub
