Function init()
    m.spinner = m.top.FindNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentChange")

    m.backRec = m.top.findnode("backRec")
    m.backRec.color = GetTheme("roku_background_overlay")
    
End Function


sub OnContentChange()
    if m.top.content <> invalid
        if m.top.content.FieldChanged <> invalid
            FieldChanged = m.top.content.FieldChanged
            m.top.content.setFields({FieldChanged : invalid})
            if FieldChanged = "SetContent"
                HandlerConfig = m.top.content.HandlerConfig
                additionalFields = {
                    id : "GetData"
                }
                LoadMoreContent(m.top.content, HandlerConfig,additionalFields)   
            else if FieldChanged = "GetData"
                m.top.screen = "HomeScreen"
            end if
        end if
    end if
end sub

Function OnWasShown()
    ShowBusySpinner(true)
End Function

sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub

sub LoadMoreContent(content, HandlerConfig,additionalFields)
    'ShowBusySpinner(true)

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            'ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additionalFields)
end sub