Function init()
    RegistryUtil().delete("UserInfo",m.global.manifest.key)
    RegistryUtil().delete("pin", m.global.manifest.key)
    RegistryUtil().delete("plive",m.global.manifest.key)
    RegistryUtil().delete("pmovie",m.global.manifest.key)
    RegistryUtil().delete("pshows",m.global.manifest.key)

    RegistryUtil().delete("Movies",m.global.manifest.key)
    RegistryUtil().delete("TVShows",m.global.manifest.key)
    RegistryUtil().delete("fav",m.global.manifest.key)


    m.spinner = m.top.findNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.logo = m.top.findnode("logo")

    m.username = m.top.findnode("username")
    m.password = m.top.findnode("password")

    m.login = m.top.findnode("login")
    m.CodeButton = m.top.findnode("CodeButton")

    m.top.ObserveField("content", "OnContentSet")
    m.top.ObserveField("wasShown", "OnWasShown")

    RegistryUtil().delete("UserInfo",m.global.manifest.key)

    m.lastfocus = invalid

    m.backRec = m.top.findnode("backRec")
    m.backRec.color = GetTheme("roku_background_overlay")

    if m.global.Udata.app_mode = "Xstream"
        m.CodeButton.visible = false
    end if
End Function

sub OnContentSet()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            UpdateThemeTop()
            SetUI()
        else if FieldChanged = "UserAuthenticated"
            if m.top.content.data <> invalid
                if m.top.content.data 
                    m.top.screen = "PrepareScreen"
                else
                    ShowBusySpinner(false)
                    m.top.Screen = "dialog/Please enter valid user credentials or check your subscription validity"
                end if
            end if
        end if
      end if
   end if
end sub

Function UpdateThemeTop()
    if m.global.Cdata.app_image <> invalid and m.global.Cdata.app_image.app_img = "true"
        back_image = m.global.Cdata.app_image.back_image
        back_color = m.global.Cdata.background.roku_color_primary
    else if m.global.Udata.app_image.app_img = "true" and m.global.Cdata.app_image <> invalid
        back_image = m.global.Udata.app_image.back_image
        back_color = m.global.Udata.background.roku_color_primary
    else
        back_image = "pkg:/images/bg.png"
        back_color = "#2E373D"
    end if

    scene = m.top.getScene()
    scene.updateTheme = {
        global: {
            backgroundImageURI: back_image
            OverhangVisible : "false"
            backgroundColor: back_color
        }
    }
End function

Function SetUI()
    if m.global.Cdata.app_image.app_img = "true"
        m.top.theme = {
            global: {
                backgroundImageURI : m.global.Cdata.app_image.back_image
            }
        }
    end if
    m.logo.uri = m.global.Cdata.app_image.app_logo
End function

Function OnWasShown()
    if m.lastfocus = invalid
        m.logo.setfocus(true)
        m.username.active = true
        ShowBusySpinner(false)
    else
        m.logo.setfocus(true)
        m.username.active = true
        ShowBusySpinner(false)
    end if
End Function


Function SetText(event as object)
    if event.field = "Username"
        m.username.text = event.text
        m.username.cursorPosition = len(m.username.text)
    else if event.field = "Password"
        m.password.text = event.text
        m.password.cursorPosition = len(m.password.text)
    end if
End Function


function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "down" 
            if m.username.active = true and m.logo.hasFocus()
                m.username.active = false
                m.password.active = true
            else if m.password.active and m.logo.hasFocus()
                m.password.active = false
                m.login.setfocus(true)  
            else if m.login.hasFocus() and m.CodeButton.visible = true
                m.CodeButton.setfocus(true)
            end if
        else if key = "up"
            if m.password.active and m.logo.hasFocus()
                m.password.active = false
                m.username.active = true
                m.logo.setfocus(true)
            else if m.login.hasfocus()
                m.logo.setfocus(true)
                m.password.active = true
            else if m.CodeButton.hasFocus()
                m.login.setfocus(true)
            end if
        else if key = "OK"
            if m.username.active 
                m.top.Screen = "LoginScreen/Username/"+m.username.text
            else if m.password.active    
                m.top.Screen = "LoginScreen/Password/"+m.password.text
            else if m.Login.hasfocus()
                if m.username.text <> "" and m.password.text <> ""
                    if m.top.content <> invalid and m.top.content.HandlerConfig <> invalid then
                        HandlerConfig = m.top.content.HandlerConfig
                        additionalFields = {
                            id : "login"
                            query : m.username.text+"/"+m.password.text
                        }
                        ShowBusySpinner(true)
                        LoadMoreContent(m.top.content, HandlerConfig,additionalFields)
                    end if
                else
                    m.top.Screen = "dialog/Please fill up all fields"    
                end if
            else if m.CodeButton.hasfocus()
                m.top.screen = "CodeScreen"    
            end if    
        end if
    end if
    return handled
end function


sub LoadMoreContent(content, HandlerConfig,additionalFields)
    'ShowBusySpinner(true)

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            'ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additionalFields)
end sub

sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub