sub init()
    m.debug = false
    m.ContentManager_id = 0
    m.spinner = m.top.findNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.backRec = m.top.findnode("backRec")

    m.back = m.top.findnode("back")

    m.VideoPlayer = m.top.findnode("VideoPlayer")
    m.VideoPlayer.ObserveField("state","onVideoStateChanged")

    m.Channellist = m.top.findnode("Channellist")
    m.Channellist.ObserveField("itemSelected","OnitemSelected")
    m.Channellist.ObserveField("itemfocused","Onitemfocused")

    m.CatName = m.top.findnode("CatName")

    m.ChannelInfo = m.top.findNode("ChannelInfo")
    m.Channel_Name = m.top.findnode("Channel_Name")
    m.current_progressBack = m.top.findNode("current_progressBack")
    m.current_progress = m.top.findNode("current_progress")
    m.epg1 = m.top.findNode("epg1")
    m.epg2 = m.top.findNode("epg2")
    m.epg3 = m.top.findNode("epg3")
    m.epg_desc = m.top.findNode("epg_desc")
    

    m.left = m.top.findnode("left")
    m.right = m.top.findnode("right")

    m.left.visible = false
    m.right.visible = false

    m.Timer = m.top.findnode("Timer")
    m.Timer.ObserveField("fire", "FireTimer")

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentSet")
    m.top.ObserveField("close", "onScreenClose")

     m.channels = []
     m.categories = []

     m.CatIndex = 0
     m.CurrentSteamID = "0"

     m.channelepg = {}

    m.blob = CreateObject("roByteArray")
    m.dt = createobject("rodatetime")

    m.FavLabel = m.top.findnode("FavLabel")
    m.CatId = invalid

    m.Channellist.focusBitmapBlendColor = GetTheme("roku_button_focus")
end sub

function onScreenClose()
    m.VideoPlayer.control = "stop"
end function

function OnWasShown()
    m.registry = RegistryUtil().read("UserInfo", m.global.manifest.key)  
    if m.registry <> invalid
        m.registry = parsejson(m.registry)  
    end if

    m.backRec.color = GetTheme("roku_background_overlay")

    if m.global.lastPlayed.name <> invalid
        data = m.global.lastPlayed
        SetVideoContent(data)
    else
        if m.global.channels <> invalid and m.global.channels.count() > 0
            data = m.global.channels[0]
            SetVideoContent(data)
        end if
    end if
end function


function FireTimer()
    if m.VideoPlayer.width = 1920 
        m.back.visible = false
        m.back.setfocus(true)
    end if
end function

Function onVideoStateChanged(event as object)
    state =  event.getdata()
    if state = "error"
       ' ? m.VideoPlayer
    else
        ? state
    end if
End Function

function onrowitemselected()
    m.VideoPlayer.width = 1920
    m.VideoPlayer.height = 1080
    m.VideoPlayer.enableUI = "true"
    m.VideoPlayer.translation = [0,0]
    m.ChannelInfo.visible = false
    m.Timer.control = "start"
    ShowBusySpinner(true)
end function

sub OnContentSet()
    if m.top.content <> invalid and  m.top.content.FieldChanged <> invalid
        FieldChanged =  m.top.content.FieldChanged
         m.top.content.setfields({FieldChanged : invalid})
        if FieldChanged = "Contentset"
            m.categories = GetCats()
            m.channels = m.global.channels
            SetContent("All")

            if m.global.lastPlayed.name <> invalid
                data = m.global.lastPlayed
            else
                if m.global.channels <> invalid and m.global.channels.count() > 0
                    data = m.global.channels[0]
                end if
            end if
            index = GetChannelIndex(m.global.channels,data)
            m.Channellist.jumpToItem = index
            ShowBusySpinner(false)
        else if FieldChanged = "channelepg"
            data = m.top.content.channelepg
            if data.epg <> invalid and data.epg.count() > 0
                setepgdata(data.epg)
            end if
        else 
        
        end if    
    end if
end sub


Function GetCats()
    cats = []
    if m.global.Livecats <> invalid 
        if RegistryUtil().read("plive",m.global.manifest.key) <> invalid
            m.Pcat = ParseJson(RegistryUtil().read("plive",m.global.manifest.key))
        else
            m.Pcat = []
        end if
        for each catItem in m.global.Livecats
            if m.global.ParentalLock = false
                cats.Push(catItem)
            else if ArrayUtil().contains(m.Pcat,catItem.category_id) = false
                cats.Push(catItem)
            end if
        end for
    end if
    return cats
End function

function OnitemSelected(event as object)
    data = m.Channellist.content.getchild(event.getdata())
    if data.stream_id.tostr() <>  m.CurrentSteamID
        SetVideoContent(data)
    else
        m.VideoPlayer.width = 1920
        m.VideoPlayer.height = 1080
        m.VideoPlayer.enableUI = "true"
        m.VideoPlayer.translation = [0,0]
        m.ChannelInfo.visible = false
        m.Timer.control = "start"
    end if

    m.CurrentSteamID = data.stream_id.tostr()
end function

Function SetVideoContent(data as object)
    content = CreateObject("roSGNode", "ContentNode")
    content.title = data.name
    content.url = m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port+"/live/"+m.registry.user_info.username+"/"+m.registry.user_info.password+"/"+data.stream_id.tostr()+".ts" 
    m.VideoPlayer.content = content
    m.VideoPlayer.control = "play"
    m.Channel_Name.text = data.name
    if m.VideoPlayer.width = 1920
        m.Timer.control = "start"
    else
        m.Timer.control = "stop"
    end if    

    index = GetChannelIndex(m.global.channels,data)
    m.global.SetFields({lastPlayed : m.global.channels[index]})
End function

function Onitemfocused(event as object)
    data = m.Channellist.content.getchild(event.getdata())
    if data <> invalid
        m.Channel_Name.text = data.name
        if m.global.Cdata.app_conf.epg_roku = "true"
            additionalFields = {
                query : "getChannelepg"
                id : data.stream_id
            }
            HandlerConfig = m.top.content.HandlerConfigLiveScreen
            LoadMoreContent(m.top.content, HandlerConfig, additionalFields) 
        end if
    end if

    m.current_progressBack.visible = false
    epgnode = [m.epg1,m.epg2,m.epg3,m.epg_desc]
    for i=0 to epgnode.count()-1
        epgnode[i].text = ""
    end for 
    
    m.Timer.control = "start"
end function

function SetContent(CatId as string)
    m.CatId = CatId
    m.FavLabel.visible = false

    if CatId =  "Fav"
        channels = GetFavData()
        if channels.count() > 0
            m.FavLabel.visible = false
        else
            m.FavLabel.visible = true
        end if
    else
        channels = m.channels
    end if

    content = CreateObject("roSGNode", "ContentNode")
    for each channel in channels
        if CatId = "All" or channel.category_id = CatId or CatId = "Fav"
            item = CreateObject("roSGNode", "ContentNode")
            item.update(channel,true)
            content.appendChild(item)
        end if
    end for

    m.Channellist.content = content
    m.Channellist.setfocus(true)

    if m.top.rowItemSelected.count() > 0
        m.Channellist.jumpToItem = m.top.rowItemSelected[0]
    end if

    m.CatName.text = m.categories[m.CatIndex].category_name
    m.right.visible = true 
    m.left.visible = false
end function

function setepgdata(epgdata as object)
    dt = createobject("rodatetime")
    currentTime = dt.AsSeconds()
    if epgdata.count() > 0
        data = GetCurrentEPG(epgdata)
        if data <> invalid
            m.blob.FromBase64String(data[0].title)
    
            m.epg1.text = SetTimes(data[0].start_timestamp)+" - "+SetTimes(data[0].stop_timestamp)+" "+m.blob.ToAsciiString()

            m.blob.FromBase64String(data[0].description)
            m.epg_desc.text = m.blob.ToAsciiString()
            
            if data[0].stop_timestamp.toint() > currentTime and data[0].start_timestamp.toint() < currentTime
                RunTime = data[0].stop_timestamp.toint() - data[0].start_timestamp.toint()
                m.current_progress.width = (m.current_progressBack.width/RunTime)*(currentTime - data[0].start_timestamp.toint())
                m.current_progressBack.visible = true
            else
                m.current_progressBack.visible = false
            end if
            
            m.blob.FromBase64String(data[1].title)
            m.epg2.text = SetTimes(data[1].start_timestamp)+" - "+SetTimes(data[1].stop_timestamp)+"  "+m.blob.ToAsciiString()

            m.blob.FromBase64String(data[2].title)
            m.epg3.text = SetTimes(data[2].start_timestamp)+" - "+SetTimes(data[2].stop_timestamp)+"  "+m.blob.ToAsciiString()
        end if
    else
        m.current_progressBack.visible = false
        epgnode = [m.epg1,m.epg2,m.epg3,m.epg_desc]
        for i=0 to epgnode.count()-1
            epgnode[i].text = ""
        end for 
    end if
end function

Function SetString(data as string)
    if Len(data) = 1
        data = "0" + data
    end if
    return data
end function

function SetTimes(data as string)
    m.dt.FromSeconds(data.toint())
    m.dt.ToLocalTime()

    min = ""
    if len(m.dt.GetMinutes().toStr()) = 1
        min = "0"+m.dt.GetMinutes().toStr()
    else
        min = m.dt.GetMinutes().toStr()
    end if

    hr = m.dt.GetHours()

    if hr >= 12 
        hr =  (hr - 12).toStr()
        cd = "PM"
    else
        hr = m.dt.GetHours().toStr()
        cd = "AM" 
    end if

    return hr+":"+min+" "+cd
end function

sub LoadMoreContent(content, HandlerConfig, additionalFields)
    'ShowBusySpinner(true)

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additionalFields)
end sub

sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub

function onkeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "back"
            if m.back.visible = true and m.VideoPlayer.width = 1920
                 FireTimer()
                 handled = true
            else if m.VideoPlayer.width = 1920
                m.VideoPlayer.width = 850
                m.VideoPlayer.height = 500
                m.VideoPlayer.translation = [1000,50]
                m.VideoPlayer.enableUI="false"
                m.Timer.control = "stop"
                m.ChannelInfo.visible = true
                m.back.visible = true
                m.Channellist.setfocus(true)
                handled = true
            else
                m.VideoPlayer.control = "stop"    
           end if
        else if key = "right"
            if m.categories.count() > m.CatIndex+1 and m.back.visible = true    
                m.Timer.control = "start"
                m.CatIndex = m.CatIndex + 1
                m.CatName.text = m.categories[m.CatIndex].category_name
                SetContent(m.categories[m.CatIndex].category_id)
                m.left.visible = true
                m.right.visible = true 
             else
                m.right.visible = false   
            end if
        else if key = "left"
            if m.CatIndex <> 0 and m.back.visible = true
                m.Timer.control = "start"
                m.CatIndex = m.CatIndex - 1
                m.CatName.text = m.categories[m.CatIndex].category_name
                SetContent(m.categories[m.CatIndex].category_id)
                if m.CatIndex = 0
                    m.right.visible = true 
                    m.left.visible = false
                else    
                    m.right.visible = true 
                    m.left.visible = true    
                end if 
            end if
        else if key = "OK"
            if  m.back.hasfocus() and m.back.visible = false
                m.back.visible = true
                m.Channellist.setfocus(true)
                m.Timer.control = "start"
            end if    
        else if key = "options"    
          if m.Channellist.hasfocus()
            data = m.Channellist.content.getchild(m.Channellist.itemfocused)
            HandleFav(data.stream_id.tostr())
            if m.CatId = "Fav"
                SetContent("Fav")
                m.left.visible = true
            end if
          end if
        end if
    end if
    return handled
end function