Function init()
    m.menulist = m.top.findnode("menulist")
    m.menulist.ObserveField("rowitemselected", "onMenuItemSelected")

    m.notificationList = m.top.findnode("notificationList")
    m.notificationList.ObserveField("rowitemselected", "onNotificationSelected")
  
    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("visible", "OnwasClosed")
    m.top.ObserveField("content", "OnContentChange")

    m.Video = m.top.findnode("Video")
    m.Video.ObserveField("state","onVideoStateChanged")

    m.Video_Focus = m.top.findnode("Video_Focus")

    m.lastfocus = invalid

    m.registry = RegistryUtil().read("UserInfo", m.global.manifest.key)  
    if m.registry <> invalid
        m.registry = parsejson(m.registry)  
    end if

    m.announcement_back = m.top.findnode("announcement_back")
    m.announcement_back.color = GetTheme("roku_color_primary")

    m.menulist.focusBitmapBlendColor = GetTheme("roku_color_secondary")
    m.Video_Focus.BlendColor = GetTheme("roku_color_secondary")

    if GetTheme("roku_background_overlay") = invalid
        ? "Demooooo"
        m.backRec.visible = false
    else
        m.backRec = m.top.findnode("backRec")
        m.backRec.color = GetTheme("roku_background_overlay")
    end if
    
    m.top.findnode("screenTitle").text = "Home"
End Function

Function OnwasClosed(Event as object)
    if Event.getdata() = false
        m.Video.control = "stop"
    end if
End Function

function onNotificationSelected(event as object)
    index = event.getData()

    content = m.notificationList.content.getchild(index[0]).getchild(index[1])
    m.top.screen = "dialog/"+content.DESCRIPTION+"/"+content.TITLE
end function


function onMenuItemSelected(event as object)
    m.lastfocus = event.GetRoSGNode()
End Function

sub OnContentChange()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            SetupUI()
            'ShowPinDialog(m.dialog.buttons[event.getdata()], "Set PIN")
        end if
      end if
   end if
end sub

Function SetupUI()
    ' if m.global.Cdata.app_image.app_img = "true"
    '     m.top.theme = {
    '         global: {
    '             backgroundImageURI : m.global.Cdata.app_image.back_image
    '         }
    '     }
    ' end if
    SetupMenu()
    SetUpNotificationContent()
End Function

Function onVideoStateChanged(event as object)
    ? event.getdata()
End Function


Function setVideoContent()
    if m.global.lastPlayed.name <> invalid
        data = m.global.lastPlayed
    else
        if m.global.channels <> invalid and m.global.channels.count() > 0
            data = m.global.channels[0]
            m.global.setFields({lastPlayed : data})
        end if
    end if
    content = CreateObject("roSGNode", "ContentNode")
    content.title = data.name
    content.url = m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port+"/live/"+m.registry.user_info.username+"/"+m.registry.user_info.password+"/"+data.stream_id.tostr()+".ts" 
    m.Video.content = content
    m.Video.control = "play"
End Function

Function SetupMenu()
    '["Live TV","Programme Guide","Catch Up","Movies","TV Shows","My Account","Settings","Log out"]
    m.menu = []

    if m.global.Livecats <> invalid and m.global.Livecats.count() > 0
        m.menu.Push("Live TV")
    end if

    if  m.global.EPGcats <> invalid and m.global.EPGcats.count() > 0 and m.global.Cdata.app_conf.epg_roku = "true"
        m.menu.Push("Programme Guide")
    end if

    if  m.global.EPGcats <> invalid and m.global.EPGcats.count() > 0 and m.global.Cdata.app_conf.epg_catchup = "true"
        m.menu.Push("Catch Up")
    end if

    if m.global.moviesCats.count() > 2
        m.menu.Push("Movies")
    end if

    if m.global.tvshowsCats.count() > 2
        m.menu.Push("TV Shows")
    end if

    m.menu.append(["My Account","Settings","Log out"])
    
    content = CreateObject("roSGNode", "ContentNode")
    row = CreateObject("roSGNode", "ContentNode")
    for each menuItem in m.menu
        item = CreateObject("roSGNode", "ContentNode")
        item.id = menuItem
        item.title = menuItem
        row.appendChild(item)
    end for
    content.appendChild(row)
    m.menulist.content = content
End Function

Function SetUpNotificationContent()
    datas = m.global.Cdata.app_announce
    ? datas
    content = CreateObject("roSGNode", "ContentNode")
    for each data in datas
        row = CreateObject("roSGNode", "ContentNode")
        item = CreateObject("roSGNode", "ContentNode")
        item.title = data.title
        item.description = data.short_description
        item.ReleaseDate = data.insert_date
        row.appendChild(item)
        content.appendChild(row)
    end for
    m.notificationList.content = content
End Function


Function OnWasShown(event as object)
    if m.lastfocus <> invalid
        ? m.lastfocus
        m.lastfocus.setfocus(true)
    end if
    setVideoContent()
End Function

function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key="up"
            if m.menulist.hasfocus()
                m.notificationList.setfocus(true)
            end if
        else if key = "down"
            if m.notificationList.hasfocus() or m.Video_Focus.hasfocus()
                m.menulist.setfocus(true)
                m.Video_Focus.visible = false
            end if
        else if key = "left"
            if m.notificationList.hasfocus()
                m.Video_Focus.setfocus(true)
                m.Video_Focus.visible = true
            end if
        else if key = "right"
            if m.Video_Focus.hasfocus()
                m.Video_Focus.visible = false
                m.notificationList.setfocus(true)
            end if
        else if key = "OK"
            if m.Video_Focus.hasfocus()
                m.lastfocus = m.Video_Focus
                m.top.screen = "LiveScreen"
            end if
        end if
    end if
    return handled
end function